function xprime=statetrackingm_derivatives(t,x)

global k1 k icon rho w  xs xsr tstart grad dt CovnT DeltaT ts tsr lambda;
global usave tsave 

x1=x(1);
x2=x(2);

z1=x1;
z2=-x1+x2;

% New system, and the minimum is not an equilibrium point
%z2=x1+x2;

dt=t-tstart;

if t==0  
   error=0; dt=CovnT; %dt=DeltaT;
else
   error=norm(x-xs);
end

% the threshold is determined from the robust analysis
if icon==1
   thresh=norm(grad)/20000
else
   thresh=norm(grad)/20
end

if (dt>=CovnT & error <=thresh)  % | (dt>DeltaT)% & error <1) 
%if (error <= thresh) % | (dt>DeltaT)% & error <1) 

%if  (dt>=DeltaT)% & error <1) 
% dt
% t
% x
% xs
% error
% thresh
% pause

if icon==1 
   % Banana Function
   [f,grad]=banana(x);  % obtain function value and gradient
   
   % perform an inexact line search satifiying Armijo condition
   % a maximum limit of 50 trial of step size is posted
   % ideally we should impose such a limitation
%    alpha1=1; 
%    for k=1:50     
%        if banana([x1+alpha1*(-grad(1)),x2+alpha1*(-grad(2))]) <= f+rho*alpha1*(-grad.')*grad
%           break;
%        end
%        alpha1=w*alpha1; 
%    end
   % alpha1=0.0015;
    %alpha1=0.0012;
    alpha1=0.0012;
    %if t>20
    %    alpha1=0.01;
    %end
elseif icon==0  
   % another cost function   
   grad=[10*x1+4*x2-14;2*x2+4*x1-6];
   %alpha1=((-grad(1))^2+(-grad(2))^2)/(2*(5*(-grad(1))^2+(-grad(2))^2+4*(-grad(1))*(-grad(2))));
   alpha1=0.15;
else
   grad=[2*(x1-2);2*(x2-3)];
   alpha1=0.3;
end
    
% obtained step length
alpha2=alpha1;
xs=[x1-alpha1*grad(1);x2-alpha2*grad(2)];   % ideal search destination
xsr(:,end+1)=xs;
tsr(:,end+1)=t;
tstart=t;
end

% generate the desired set point
zs(1)=xs(1);
zs(2)=-xs(1)+xs(2);
%new system
%zs(2)=xs(1)+xs(2);


% % generate a stable refernce trajectory that set point
% a1=(lambda*zs(1)+zs(2))/lambda;
% a2=-zs(2)/(exp(-lambda*ts)*lambda);
% % tstart
% zs1=a1+a2*exp(-(t-tstart));
% zs2=-a2*exp(-(t-tstart));
% zs3=a2*exp(-(t-tstart));

% generate a periodic refernce trajectory
a2=zs(1);
w1=2*pi/ts;
a1=zs(2)/w1;

% w1=(pi/6)/ts;
% a1=zs(2)/(w1*cos(w1*ts));
% a2=zs(1)-a1*sin(w1*ts);

zs1=a1*sin(w1*t)+a2;
zs2=a1*w1*cos(w1*t);
zs3=-a1*w1*w1*sin(w1*t);

% error systems
e=k1*(z1-zs1)+(z2-zs2);
xi=k1*(z2-zs2)-zs3;

u=-xi+(-x1+x2)-x1*x2-k*e;
%new system
%u=-xi-(x1+x2)-x1*x2-k*e;

% Norminal Controller
% step length is 0.0012, CovnT=0.5,  Ts=5
% k1=3; k=3;

% Stabilizing Term
% For smooth version of the nonlinear damping term
% step length is 0.0012, CovnT=0.5,  Ts=5
% k1=3; k=3;
% us=-5*e/(abs(e)+0.3); 

% Stabilizing term for unbounded disturbance
% k1=3, k-1.5, eta=2; 
% step length is 0.001, CovnT=1,  DeltaT=3, disturbance is
% 1/(abs(x1)+0.01)+3*(cos(t)+1)*(x2))
eta=1;
us=-eta*e*(1/(abs(z1)+0.01)+6*(z1+z2))^2;


%us=-3*e/(abs(e)+0.05);
%us=-3*sign(e);%
%eta=2;
%us=-eta*e*(1/(abs(z1)+0.01)+6*(z1+z2))^2;


%u=u+us;

% Plant dynamics
xprime(1)=-x1+x2;
%new system
%xprime(1)=x1+x2;

xprime(2)=x1*x2+u;
% with bounded input disturbance 
%xprime(2)=x1*x2+(u+5*rand(1)); 
% with unbounded input disturbance
%xprime(2) = x1*x2+(u+1/(abs(x1)+0.01)+3*(cos(t)+1)*(x2));

xprime=xprime.';


tsave = [tsave;t];
usave = [usave;u];